/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8705;
import net.minecraft.class_8706;
import net.minecraft.class_8710;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.McHelper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.CountDownInt;
import qouteall.q_misc_util.my_util.DQuaternion;

public class ImplRemoteProcedureCall {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final CountDownInt LOGGING_LIMIT = new CountDownInt(100);
    private static final CountDownInt ERROR_MESSAGE_LIMIT = new CountDownInt(10);
    public static final Gson gson = MiscHelper.gson;
    private static final ConcurrentHashMap<String, Method> methodCache = new ConcurrentHashMap();
    private static final ImmutableMap<Class, BiConsumer<class_9129, Object>> serializerMap = ImmutableMap.builder().put(class_2960.class, (buf, o) -> buf.method_10812((class_2960)o)).put(class_5321.class, (buf, o) -> buf.method_10812(((class_5321)o).method_29177())).put(class_2338.class, (buf, o) -> buf.method_10807((class_2338)o)).put(class_243.class, (buf, o) -> {
        class_243 vec = (class_243)o;
        buf.method_52940(vec.field_1352);
        buf.method_52940(vec.field_1351);
        buf.method_52940(vec.field_1350);
    }).put(UUID.class, (buf, o) -> buf.method_10797((UUID)o)).put(class_2248.class, (buf, o) -> ImplRemoteProcedureCall.serializeByCodec((class_2540)buf, class_7923.field_41175.method_39673(), o)).put(class_1792.class, (buf, o) -> ImplRemoteProcedureCall.serializeByCodec((class_2540)buf, class_7923.field_41178.method_39673(), o)).put(class_2680.class, (buf, o) -> ImplRemoteProcedureCall.serializeByCodec((class_2540)buf, class_2680.field_24734, o)).put(class_1799.class, (buf, o) -> ImplRemoteProcedureCall.serializeByCodec((class_2540)buf, class_1799.field_24671, o)).put(class_2487.class, (buf, o) -> buf.method_10794((class_2520)((class_2487)o))).put(class_2561.class, (buf, o) -> class_8824.field_49666.encode(buf, (Object)((class_2561)o))).put(DQuaternion.class, (buf, o) -> {
        DQuaternion dQuaternion = (DQuaternion)o;
        buf.method_52940(dQuaternion.x);
        buf.method_52940(dQuaternion.y);
        buf.method_52940(dQuaternion.z);
        buf.method_52940(dQuaternion.w);
    }).put(byte[].class, (buf, o) -> buf.method_10813((byte[])o)).build();
    private static final ImmutableMap<Type, Function<class_9129, Object>> deserializerMap = ImmutableMap.builder().put(class_2960.class, class_2540::method_10810).put((Object)new TypeToken<class_5321<class_1937>>(){}.getType(), buf -> class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)buf.method_10810())).put((Object)new TypeToken<class_5321<class_1959>>(){}.getType(), buf -> class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)buf.method_10810())).put(class_2338.class, buf -> buf.method_10811()).put(class_243.class, buf -> new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble())).put(UUID.class, buf -> buf.method_10790()).put(class_2248.class, buf -> ImplRemoteProcedureCall.deserializeByCodec(buf, class_7923.field_41175.method_39673())).put(class_1792.class, buf -> ImplRemoteProcedureCall.deserializeByCodec(buf, class_7923.field_41178.method_39673())).put(class_2680.class, buf -> ImplRemoteProcedureCall.deserializeByCodec(buf, class_2680.field_24734)).put(class_1799.class, buf -> ImplRemoteProcedureCall.deserializeByCodec(buf, class_1799.field_24671)).put(class_2487.class, buf -> buf.method_10798()).put(class_2561.class, arg_0 -> ((class_9139)class_8824.field_49666).decode(arg_0)).put(DQuaternion.class, buf -> new DQuaternion(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble())).put(byte[].class, buf -> buf.method_10795()).build();

    public static void init() {
        PayloadTypeRegistry.playC2S().register(C2SRPCPayload.TYPE, C2SRPCPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(S2CRPCPayload.TYPE, S2CRPCPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(C2SRPCPayload.TYPE, C2SRPCPayload::handle);
    }

    @Environment(value=EnvType.CLIENT)
    public static void initClient() {
        ClientPlayNetworking.registerGlobalReceiver(S2CRPCPayload.TYPE, S2CRPCPayload::handle);
    }

    private static Object deserializeByCodec(class_9129 buf, Codec codec) {
        String jsonString = buf.method_19772();
        JsonElement jsonElement = JsonParser.parseString((String)jsonString);
        return codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow();
    }

    private static Object deserializeArgument(class_9129 buf, Type type) {
        Function deserializer = (Function)deserializerMap.get((Object)type);
        if (deserializer == null) {
            String json = buf.method_19772();
            return gson.fromJson(json, type);
        }
        return deserializer.apply(buf);
    }

    private static void serializeArgument(class_9129 buf, Object object) {
        BiConsumer serializer = (BiConsumer)serializerMap.get(object.getClass());
        if (serializer == null) {
            serializer = serializerMap.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(object.getClass())).findFirst().map(Map.Entry::getValue).orElse(null);
        }
        if (serializer == null) {
            String json = gson.toJson(object);
            buf.method_10814(json);
            return;
        }
        serializer.accept(buf, object);
    }

    private static void serializeByCodec(class_2540 buf, Codec codec, Object object) {
        JsonElement result = (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, object).getOrThrow();
        String jsonString = gson.toJson(result);
        buf.method_10814(jsonString);
    }

    @Environment(value=EnvType.CLIENT)
    public static class_2596<class_8706> createC2SPacket(String methodPath, Object ... arguments) {
        return ClientPlayNetworking.createC2SPacket((class_8710)new C2SRPCPayload(true, methodPath, null, List.of(arguments)));
    }

    public static class_2596<class_8705> createS2CPacket(String methodPath, Object ... arguments) {
        return ServerPlayNetworking.createS2CPacket((class_8710)new S2CRPCPayload(true, methodPath, null, List.of(arguments)));
    }

    @Environment(value=EnvType.CLIENT)
    private static void clientTellFailure() {
        class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)"The client failed to process a packet from server. See the log for details.").method_27692(class_124.field_1061));
    }

    private static void serverTellFailure(class_3222 player) {
        player.method_43496((class_2561)class_2561.method_43470((String)"The server failed to process a packet sent from client.").method_27692(class_124.field_1061));
    }

    private static Method getMethodByPath(String methodPath) {
        Method result = methodCache.get(methodPath);
        if (result != null) {
            return result;
        }
        Method method = ImplRemoteProcedureCall.findMethodByPath(methodPath);
        Validate.notNull((Object)method);
        methodCache.put(methodPath, method);
        return method;
    }

    private static Method findMethodByPath(String methodPath) {
        Class<?> aClass;
        int lastDotIndex = methodPath.lastIndexOf(46);
        Validate.isTrue((lastDotIndex != -1 ? 1 : 0) != 0);
        String classPath = methodPath.substring(0, lastDotIndex);
        String methodName = methodPath.substring(lastDotIndex + 1);
        if (!classPath.contains("RemoteCallable")) {
            throw new RuntimeException("The class path must contain \"RemoteCallable\"");
        }
        try {
            aClass = Class.forName(classPath);
        }
        catch (ClassNotFoundException e) {
            int dotIndex = classPath.lastIndexOf(46);
            if (dotIndex != -1) {
                String newClassPath = classPath.substring(0, dotIndex) + "$" + classPath.substring(dotIndex + 1);
                try {
                    aClass = Class.forName(newClassPath);
                }
                catch (ClassNotFoundException e1) {
                    throw new RuntimeException("Cannot find class " + classPath, e);
                }
            }
            throw new RuntimeException("Cannot find class " + classPath, e);
        }
        Method method = Arrays.stream(aClass.getMethods()).filter(m -> m.getName().equals(methodName)).findFirst().orElseThrow(() -> new RuntimeException("Cannot find method " + methodPath + " . If it's a private method, make it public."));
        return method;
    }

    public record C2SRPCPayload(boolean deserializeSuccess, @Nullable String methodPath, @Nullable Method method, @Nullable List<Object> args) implements class_8710
    {
        public static final class_8710.class_9154<C2SRPCPayload> TYPE = new class_8710.class_9154(McHelper.newResourceLocation("iportal:remote_c2s"));
        public static final class_9139<class_9129, C2SRPCPayload> CODEC = class_9139.method_56437((b, p) -> p.write((class_9129)b), C2SRPCPayload::read);

        public static C2SRPCPayload read(class_9129 buf) {
            String methodPath = null;
            try {
                methodPath = buf.method_19772();
                Method method = ImplRemoteProcedureCall.getMethodByPath(methodPath);
                Type[] genericParameterTypes = method.getGenericParameterTypes();
                ArrayList<Object> args = new ArrayList<Object>();
                for (int i = 1; i < genericParameterTypes.length; ++i) {
                    Type parameterType = genericParameterTypes[i];
                    Object obj = ImplRemoteProcedureCall.deserializeArgument(buf, parameterType);
                    args.add(obj);
                }
                return new C2SRPCPayload(true, methodPath, method, args);
            }
            catch (Exception e) {
                if (LOGGING_LIMIT.tryDecrement()) {
                    LOGGER.error("Failed to parse remote procedure call {}", (Object)methodPath, (Object)e);
                }
                return new C2SRPCPayload(false, methodPath, null, null);
            }
        }

        public void write(class_9129 buf) {
            Validate.notNull(this.args, (String)"args must not be null", (Object[])new Object[0]);
            Validate.notNull((Object)this.methodPath, (String)"methodPath must not be null", (Object[])new Object[0]);
            buf.method_10814(this.methodPath);
            for (Object arg : this.args) {
                ImplRemoteProcedureCall.serializeArgument(buf, arg);
            }
        }

        public void handle(ServerPlayNetworking.Context c) {
            block5: {
                if (!this.deserializeSuccess) {
                    if (ERROR_MESSAGE_LIMIT.tryDecrement()) {
                        ImplRemoteProcedureCall.serverTellFailure(c.player());
                    }
                    return;
                }
                Validate.notNull(this.args, (String)"args must not be null", (Object[])new Object[0]);
                Validate.notNull((Object)this.method, (String)"method must not be null", (Object[])new Object[0]);
                class_3222 player = c.player();
                try {
                    Object[] argArray = new Object[this.args.size() + 1];
                    argArray[0] = player;
                    for (int i = 0; i < this.args.size(); ++i) {
                        argArray[i + 1] = this.args.get(i);
                    }
                    this.method.invoke(null, argArray);
                }
                catch (Exception e) {
                    if (!LOGGING_LIMIT.tryDecrement()) break block5;
                    LOGGER.error("Failed to invoke remote procedure call {} {}", new Object[]{this.methodPath, player, e});
                    ImplRemoteProcedureCall.serverTellFailure(c.player());
                }
            }
        }

        @NotNull
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    public record S2CRPCPayload(boolean deserializeSuccess, @Nullable String methodPath, @Nullable Method method, @Nullable List<Object> args) implements class_8710
    {
        public static final class_8710.class_9154<S2CRPCPayload> TYPE = new class_8710.class_9154(McHelper.newResourceLocation("iportal:remote_s2c"));
        public static final class_9139<class_9129, S2CRPCPayload> CODEC = class_9139.method_56437((b, p) -> p.write((class_9129)b), S2CRPCPayload::read);

        public static S2CRPCPayload read(class_9129 buf) {
            String methodPath = null;
            try {
                methodPath = buf.method_19772();
                Method method = ImplRemoteProcedureCall.getMethodByPath(methodPath);
                Type[] genericParameterTypes = method.getGenericParameterTypes();
                ArrayList<Object> args = new ArrayList<Object>();
                for (Type parameterType : genericParameterTypes) {
                    Object obj = ImplRemoteProcedureCall.deserializeArgument(buf, parameterType);
                    args.add(obj);
                }
                return new S2CRPCPayload(true, methodPath, method, args);
            }
            catch (Exception e) {
                if (LOGGING_LIMIT.tryDecrement()) {
                    LOGGER.error("Failed to parse remote procedure call {}", (Object)methodPath, (Object)e);
                }
                return new S2CRPCPayload(false, methodPath, null, null);
            }
        }

        public void write(class_9129 buf) {
            Validate.notNull(this.args, (String)"args must not be null", (Object[])new Object[0]);
            Validate.notNull((Object)this.methodPath, (String)"methodPath must not be null", (Object[])new Object[0]);
            buf.method_10814(this.methodPath);
            for (Object arg : this.args) {
                ImplRemoteProcedureCall.serializeArgument(buf, arg);
            }
        }

        @Environment(value=EnvType.CLIENT)
        public void handle(ClientPlayNetworking.Context c) {
            block4: {
                if (!this.deserializeSuccess) {
                    if (ERROR_MESSAGE_LIMIT.tryDecrement()) {
                        ImplRemoteProcedureCall.clientTellFailure();
                    }
                    return;
                }
                Validate.notNull(this.args, (String)"args must not be null", (Object[])new Object[0]);
                Validate.notNull((Object)this.method, (String)"method must not be null", (Object[])new Object[0]);
                try {
                    Object[] argArray = this.args.toArray(new Object[0]);
                    this.method.invoke(null, argArray);
                }
                catch (Exception e) {
                    if (!LOGGING_LIMIT.tryDecrement()) break block4;
                    LOGGER.error("Failed to invoke remote procedure call {}", (Object)this.methodPath, (Object)e);
                    ImplRemoteProcedureCall.clientTellFailure();
                }
            }
        }

        @NotNull
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }
}

